const { createApp } = Vue

createApp({
    data() {
        return {
            inGameName: "Unknown",
            tag: "xxxx",
            apiKey: "RIOT_API_KEY_HERE",
            player: {
                name: "Unknown Player",
                tag: "xxxx",
                puuid: "Unknown",
                averageKDA: 0
            },
            match: {
                start: 0,
                count: 10
            },
            matches: []
        }
    },
    methods: {
        getPlayerData() {
            const playerApi =
                `https://europe.api.riotgames.com/riot/account/v1/accounts/by-riot-id/` +
                `${this.inGameName}/${this.tag}?api_key=${this.apiKey}`

            axios.get(playerApi)
                .then(response => {
                    this.player.name = response.data.gameName
                    this.player.tag = response.data.tagLine
                    this.player.puuid = response.data.puuid

                    this.getMatchIds()
                })
                .catch(error => {
                    console.error("Error fetching player data:", error)
                })
        },
        getMatchIds() {
            const matchApi =
                `https://europe.api.riotgames.com/lol/match/v5/matches/by-puuid/` +
                `${this.player.puuid}/ids?start=${this.match.start}&count=${this.match.count}` +
                `&api_key=${this.apiKey}`
            
            axios.get(matchApi)
                .then(response => {
                    this.getMatchDetails(response.data)
                })
                .catch(error => {
                    console.error("Error fetching match ids:", error)
                })
        },
        getMatchDetails(matchIds) {
            this.matches = []

            matchIds.forEach(matchId => {
                axios.get(`https://europe.api.riotgames.com/lol/match/v5/matches/${matchId}?api_key=${this.apiKey}`)
                    .then(response => {
                        const info = response.data.info

                        const player = info.participants.find(
                            p => p.puuid === this.player.puuid
                        )

                        if (!player) return

                        this.matches.push({
                            matchId,
                            win: player.win,
                            champion: player.championName,
                            kills: player.kills,
                            deaths: player.deaths,
                            assists: player.assists,
                            kda: player.challenges.kda.toFixed(2)
                        })
                    })
                    .catch(error => {
                        console.error(`Error fetching match ${matchId}:`, error)
                    })
            })
        }   
    }
}).mount('#app')
